﻿<%@ Page Language="c#" autoeventwireup="false" CodePage="1200" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ import Namespace="Soneta.Kalend" %>
<%@ import Namespace="Soneta.Kadry" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Business" %>
<script runat="server">

    public class SrParams : SerializableContextBase {
        public SrParams(Context context) : base(context) {
        }

        bool wydzial = true;
        [Caption("Nazwa wydziału")]
        public bool Wydzial {
            get { return wydzial; }
            set {
                wydzial = value;
                OnChanged(EventArgs.Empty);
            }
        }
    }

    SrParams srpars;
    [SettingsContext]
    public SrParams SrPars {
        get { return srpars; }
        set { srpars = value; }
    }		

    public class Params: ContextBase {
        public Params(Context context): base(context) {
        }

        DefinicjaBadaniaLekarskiego[] definicja;
        [Caption("Definicja")]
        public DefinicjaBadaniaLekarskiego[] Definicja {
            get { return definicja; }
            set {
                definicja = value;
                OnChanged(EventArgs.Empty);
            }
        }

        public object GetListDefinicja() {
            KadryModule kadry = KadryModule.GetInstance(this);
            Soneta.Business.View v = kadry.DefBadanLek.WgNazwy.CreateView();
            v.Condition &= new FieldCondition.NotEqual("Blokada", true);
            return v;
        }
    }

    [Context]
    public Params Param {
        set {
            definicja = value.Definicja;
        }
    }

    DefinicjaBadaniaLekarskiego[] definicja;

    RowCondition condition = RowCondition.Empty;
    
    void OnContextLoad(Object sender, EventArgs args) {
        ReportHeader1["DEFINICJA"] = Info("Definicja", "Definicje", (definicja != null) ? definicja : new object[] { "(razem)" });
        Row[] rows = (Row[])dc[typeof(Row[])];

        if (definicja != null && definicja.Length > 0)
            condition &= new FieldCondition.In("Definicja", definicja);
        condition &= new FieldCondition.Equal("Anulowany", false);
        condition &= new FieldCondition.Null("Następne", true);

        IEnumerable lst = rows;
        bool UI = rows.Length > 0 ? (rows[0] is Pracownik) : false;
        if (!UI) {
            FromTo okres = ((OkresContext)dc[typeof(OkresContext)]).Okres;
            SubTable st = KadryModule.GetInstance(dc).Pracownicy.WgNazwiska;
            RowCondition rcEtat = RowCondition.IsIntersected("Etat.Okres", okres);
            RowCondition rcUmowa = RowCondition.IsIntersected("Okres", okres);
            RowCondition rc = new RowCondition.Exists("PracHistorie", "Pracownik", rcEtat) |
                new RowCondition.Exists("Umowa", "Pracownik", rcUmowa);
            lst = st[rc];
        }
        
        Grid1.DataSource = lst;

        colWydzial.Visible = srpars.Wydzial;
    }

    protected void Grid1_BeforeRow(object sender, RowEventArgs args) {
        Pracownik prac = (Pracownik)args.Row;
        Soneta.Business.View v = prac.BadaniaLekarskie.CreateView();
        bool ex1 = v.Count ==0;
        v.Condition &= condition;
        bool ex2 = v.Count !=0;

        bool any = false;

        if (ex1 || ex2) {
            any = true;
            colKod.AddLine(prac.Kod);
            colNazwisko.AddLine(prac.Nazwisko + " " + prac.Imie);
        }

        args.VisibleRow = any;
    }

    static string Info(string singleLabel, string multiLabel, params object[] lst) {
        if (lst == null || lst.Length == 0)
            return "";
        else if (lst.Length == 1)
            return string.Format("</strong>|{0}: <strong>{1}", singleLabel, ToHTML(lst[0]));
        string info = "";
        foreach (object obj in lst)
            if (info == "")
                info = ToHTML(obj);
            else
                info += "</strong>, <strong>" + ToHTML(obj);
        return string.Format("</strong>|{0}: <strong>{1}", multiLabel, info);

    }

    static string ToHTML(object value) {
        return HttpUtility.HtmlEncode(value.ToString());
    }
    
</script>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
    <title>Badania okresowe</title> 
    <meta content="Microsoft Visual Studio 7.0" name="GENERATOR" />
    <meta content="C#" name="CODE_LANGUAGE" />
    <meta content="JavaScript" name="vs_defaultClientScript" />
    <meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema" />
</head>
<body>
    <form id="BadaniaOkresowe" method="post" runat="server">
        <ea:datacontext id="dc" runat="server" oncontextload="OnContextLoad"></ea:datacontext>
        <cc1:ReportHeader NagłówekOddziału="NagłówekOddziału" id="ReportHeader1" title="Pracownicy bez terminu następnego badania|%DEFINICJA%"
            runat="server"></cc1:ReportHeader>
        <ea:Grid id="Grid1" runat="server" RowTypeName="Soneta.Kadry.BadanieLekarskie" onbeforerow="Grid1_BeforeRow">
            <Columns>
                <ea:GridColumn Width="4" Align="Right" VAlign="Top" DataMember="#" Caption="Lp."></ea:GridColumn>
                <ea:GridColumn Width="15" Align="Left" VAlign="Top" ID="colKod" Caption="Kod" EncodeHTML="true"></ea:GridColumn>
                <ea:GridColumn Align="Left" VAlign="Top" Caption="Nazwisko i imię" ID="colNazwisko" EncodeHTML="true"></ea:GridColumn>
                <ea:GridColumn Width="20" Align="Left" VAlign="Top" DataMember="Workers.Info.Historia.Etat.Wydzial.Kod" Caption="Wydział~Kod" EncodeHTML="true"></ea:GridColumn>
                <ea:GridColumn Width="30" Align="Left" VAlign="Top" DataMember="Workers.Info.Historia.Etat.Wydzial.Nazwa" Caption="Wydział~Nazwa" EncodeHTML="true" ID="colWydzial"></ea:GridColumn>
            </Columns>
        </ea:Grid>
        <cc1:ReportFooter id="ReportFooter1" runat="server" TheEnd="False"></cc1:ReportFooter>
    </form>
</body>
</html>
